# !/bin/bash

export PYTHONUNBUFFERED=1
export OMP_NUM_THREADS=1
export CUDA_VISIBLE_DEVICES=0
ulimit -n 65535

options=("action_space_expansion" "action_space_contraction" "action_space_expansion_contraction" "action_space_contraction_expansion")

# Minigrid
for option in "${options[@]}"; do
  for i in {0..9} ; do
    python main.py --config-file configs/minigrid/impala_minigrid.json --order --option $option --resume-id $i
    python main.py --config-file configs/minigrid/finetune_minigrid.json --order --option $option --resume-id $i
    python main.py --config-file configs/minigrid/ewc_minigrid.json --order --option $option --resume-id $i
    python main.py --config-file configs/minigrid/online_ewc_minigrid.json --order --option $option --resume-id $i
    python main.py --config-file configs/minigrid/mask_minigrid.json --order --option $option --resume-id $i
    python main.py --config-file configs/minigrid/clear_minigrid.json --order --option $option --resume-id $i
    python main.py --config-file configs/minigrid/arc_rl_minigrid.json --order --option $option --resume-id $i
  done
done


# Procgen
for option in "${options[@]}"; do
  for i in {0..4} ; do
    python main.py --config-file configs/procgen/action_space/mask_procgen.json --order --option $option --resume-id $i
    python main.py --config-file configs/procgen/action_space/finetune_procgen.json --order --option $option --resume-id $i
    python main.py --config-file configs/procgen/action_space/ewc_procgen.json --order --option $option --resume-id $i
    python main.py --config-file configs/procgen/action_space/online_ewc_procgen.json --option $option --order --resume-id $i
    python main.py --config-file configs/procgen/action_space/clear_procgen.json --order --option $option --resume-id $i
    python main.py --config-file configs/procgen/action_space/impala_procgen.json --order --option $option --resume-id $i
    python main.py --config-file configs/procgen/action_space/arc_rl_procgen.json --order --option $option --resume-id $i
  done
done